%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_par_corr
%
% Scope:    plot overview figure parameter correction (delta-values)
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           index of parameter used for correction (double),
%           index of "target" variables that are being corrected (double),
%           slope of linear fit (double)
%           intercept of linear fit (double)
%           index of anchor gas (double)
%           plot title (string)
%
% Output:   overview figure parameter correction (delta-values)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_par_corr(data,bindata,binref,gasnames,bindata_idx,target_idx,slope,intercept,ind_anchor,titlename)

figure;
for z=1:width(target_idx)
    
    subplot(3,2,2*z-1);
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,1),bindata.(gasnames{1,i})(:,target_idx(1,z)),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,target_idx(1,z)),binref.std(:,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    if z==1
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(lll,'location','northeast');
        title({sprintf('%s',titlename)}); 
    end
   
    subplot(3,2,2*z);
    scatter(bindata.(gasnames{1,ind_anchor})(:,bindata_idx),bindata.(gasnames{1,ind_anchor})(:,target_idx(1,z)));
    hold on;
    plot([min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))],slope(z,1)*[min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))]+intercept(z,1),'-r');
    yline(binref.(gasnames{1,ind_anchor})(1,target_idx(1,z)),'--k');
    xline(binref.(gasnames{1,ind_anchor})(1,bindata_idx),'--k');
    grid on;
    box on;
    xlabel({sprintf('%s',bindata.varlabels{1,bindata_idx})},'fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    legend(string(gasnames{1,ind_anchor}),'linear fit','fontsize',10);
  
     % calculate r^2
     yy = bindata.(gasnames{1,ind_anchor})(:,target_idx(1,z));
     yy_calc = slope(z,1)*bindata.(gasnames{1,ind_anchor})(:,bindata_idx)+intercept(z,1);
     rsquared = 1 - sum((yy - yy_calc).^2)/sum((yy - mean(yy)).^2);
     XL = get(gca, 'XLim');
     YL = get(gca, 'YLim');
     text(XL(1,1)+0.02*(XL(1,2)-XL(1,1)),YL(1,1)+0.92*(YL(1,2)-YL(1,1)),['{\itR^2} = ', sprintf('%1.3f',rsquared) ],'color','r');
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);
    
end
